import '../../domain/handlers/handlers.dart';
import '../../domain/models/response/stories_response.dart';

abstract class StoriesRepository {
  Future<ApiResult<StoriesResponse>> getStories({int? page});

  Future<ApiResult<void>> deleteStories(int id);

  Future<ApiResult> createStories({
    required List<String> images,
    int? serviceId,
    int? productId,
  });

  Future<ApiResult> updateStories({
    required List<String> images,
    int? id,
    String? modelType,
    required int storyId,
  });
}
